"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    product_id: str,
    provisioning_artifact_id: str,
    page_size: int = None,
    page_token: str = None,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.

    Args:
        product_id(str): The product identifier. For example, prod-abcdzk7xy33qa.
        provisioning_artifact_id(str): The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.for_provisioning_artifact.list(
                ctx, product_id=value, provisioning_artifact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.for_provisioning_artifact.list product_id=value, provisioning_artifact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_service_actions_for_provisioning_artifact",
        op_kwargs={
            "ProductId": product_id,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "PageSize": page_size,
            "PageToken": page_token,
            "AcceptLanguage": accept_language,
        },
    )
