"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    provisioned_product_id: str,
    service_action_id: str,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.

    Args:
        provisioned_product_id(str): The identifier of the provisioned product.
        service_action_id(str): The self-service action identifier.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.service_action.execution_parameter.describe_all(
                ctx, provisioned_product_id=value, service_action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.service_action.execution_parameter.describe_all provisioned_product_id=value, service_action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_service_action_execution_parameters",
        op_kwargs={
            "ProvisionedProductId": provisioned_product_id,
            "ServiceActionId": service_action_id,
            "AcceptLanguage": accept_language,
        },
    )
