"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    tag_option_id: str,
    resource_type: str = None,
    page_size: int = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the resources associated with the specified TagOption.

    Args:
        tag_option_id(str): The TagOption identifier.
        resource_type(str, optional): The resource type.    Portfolio     Product   . Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.resource_for_tag_option.list(
                ctx, tag_option_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.resource_for_tag_option.list tag_option_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_resources_for_tag_option",
        op_kwargs={
            "TagOptionId": tag_option_id,
            "ResourceType": resource_type,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )
