"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    accept_language: str = None,
    access_level_filter: Dict = None,
    search_filter: Dict = None,
    page_size: int = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the specified requests or all performed requests.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        access_level_filter(Dict, optional): The access level to use to obtain results. The default is User. Defaults to None.
        search_filter(Dict, optional): The search filter to scope the results. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.record.history.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.record.history.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_record_history",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "AccessLevelFilter": access_level_filter,
            "SearchFilter": search_filter,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )
