"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    accept_language: str = None,
    product_id: str = None,
    product_name: str = None,
    provisioning_artifact_id: str = None,
    provisioning_artifact_name: str = None,
    path_id: str = None,
    path_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the configuration required to provision the specified product using the specified provisioning artifact. If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to ProvisionProduct, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags[N]:Value". Tag the provisioned product with the value sc-tagoption-conflict-portfolioId-productId.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str, optional): The product identifier. You must provide the product name or ID, but not both. Defaults to None.
        product_name(str, optional): The name of the product. You must provide the name or ID, but not both. Defaults to None.
        provisioning_artifact_id(str, optional): The identifier of the provisioning artifact. You must provide the name or ID, but not both. Defaults to None.
        provisioning_artifact_name(str, optional): The name of the provisioning artifact. You must provide the name or ID, but not both. Defaults to None.
        path_id(str, optional): The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use ListLaunchPaths. You must provide the name or ID, but not both. Defaults to None.
        path_name(str, optional): The name of the path. You must provide the name or ID, but not both. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioning.parameter.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioning.parameter.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_provisioning_parameters",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "ProductName": product_name,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "ProvisioningArtifactName": provisioning_artifact_name,
            "PathId": path_id,
            "PathName": path_name,
        },
    )
