"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    product_id: str,
    parameters: Dict,
    idempotency_token: str,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a provisioning artifact (also known as a version) for the specified product. You cannot create a provisioning artifact for a product that was shared with you. The user or role that performs this operation must have the cloudformation:GetTemplate IAM policy permission. This policy permission is required when using the ImportFromPhysicalId template source in the information data section.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str): The product identifier.
        parameters(Dict): The configuration for the provisioning artifact.
        idempotency_token(str): A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioning.artifact.init.create(
                ctx, product_id=value, parameters=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioning.artifact.init.create product_id=value, parameters=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="create_provisioning_artifact",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "Parameters": parameters,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(
    hub,
    ctx,
    product_id: str,
    provisioning_artifact_id: str,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified provisioning artifact (also known as a version) for the specified product. You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str): The product identifier.
        provisioning_artifact_id(str): The identifier of the provisioning artifact.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioning.artifact.init.delete(
                ctx, product_id=value, provisioning_artifact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioning.artifact.init.delete product_id=value, provisioning_artifact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="delete_provisioning_artifact",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "ProvisioningArtifactId": provisioning_artifact_id,
        },
    )


async def describe(
    hub,
    ctx,
    accept_language: str = None,
    provisioning_artifact_id: str = None,
    product_id: str = None,
    provisioning_artifact_name: str = None,
    product_name: str = None,
    verbose: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified provisioning artifact (also known as a version) for the specified product.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        provisioning_artifact_id(str, optional): The identifier of the provisioning artifact. Defaults to None.
        product_id(str, optional): The product identifier. Defaults to None.
        provisioning_artifact_name(str, optional): The provisioning artifact name. Defaults to None.
        product_name(str, optional): The product name. Defaults to None.
        verbose(bool, optional): Indicates whether a verbose level of detail is enabled. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioning.artifact.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioning.artifact.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_provisioning_artifact",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "ProductId": product_id,
            "ProvisioningArtifactName": provisioning_artifact_name,
            "ProductName": product_name,
            "Verbose": verbose,
        },
    )


async def list_all(hub, ctx, product_id: str, accept_language: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all provisioning artifacts (also known as versions) for the specified product.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str): The product identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioning.artifact.init.list_all(
                ctx, product_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioning.artifact.init.list_all product_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_provisioning_artifacts",
        op_kwargs={"AcceptLanguage": accept_language, "ProductId": product_id},
    )


async def update(
    hub,
    ctx,
    product_id: str,
    provisioning_artifact_id: str,
    accept_language: str = None,
    name: str = None,
    description: str = None,
    active: bool = None,
    guidance: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified provisioning artifact (also known as a version) for the specified product. You cannot update a provisioning artifact for a product that was shared with you.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str): The product identifier.
        provisioning_artifact_id(str): The identifier of the provisioning artifact.
        name(str, optional): The updated name of the provisioning artifact. Defaults to None.
        description(str, optional): The updated description of the provisioning artifact. Defaults to None.
        active(bool, optional): Indicates whether the product version is active. Inactive provisioning artifacts are invisible to end users. End users cannot launch or update a provisioned product from an inactive provisioning artifact. Defaults to None.
        guidance(str, optional): Information set by the administrator to provide guidance to end users about which provisioning artifacts to use. The DEFAULT value indicates that the product version is active. The administrator can set the guidance to DEPRECATED to inform users that the product version is deprecated. Users are able to make updates to a provisioned product of a deprecated version but cannot launch new provisioned products using a deprecated version. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioning.artifact.init.update(
                ctx, product_id=value, provisioning_artifact_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioning.artifact.init.update product_id=value, provisioning_artifact_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_provisioning_artifact",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "Name": name,
            "Description": description,
            "Active": active,
            "Guidance": guidance,
        },
    )
