"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    service_action_id: str,
    page_size: int = None,
    page_token: str = None,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all provisioning artifacts (also known as versions) for the specified self-service action.

    Args:
        service_action_id(str): The self-service action identifier. For example, act-fs7abcd89wxyz.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioning.artifact.for_service_action.list(
                ctx, service_action_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioning.artifact.for_service_action.list service_action_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_provisioning_artifacts_for_service_action",
        op_kwargs={
            "ServiceActionId": service_action_id,
            "PageSize": page_size,
            "PageToken": page_token,
            "AcceptLanguage": accept_language,
        },
    )
