"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def execute(
    hub,
    ctx,
    provisioned_product_id: str,
    service_action_id: str,
    execute_token: str,
    accept_language: str = None,
    parameters: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Executes a self-service action against a provisioned product.

    Args:
        provisioned_product_id(str): The identifier of the provisioned product.
        service_action_id(str): The self-service action identifier. For example, act-fs7abcd89wxyz.
        execute_token(str): An idempotency token that uniquely identifies the execute request.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        parameters(Dict, optional): A map of all self-service action parameters and their values. If a provided parameter is of a special type, such as TARGET, the provided value will override the default value generated by AWS Service Catalog. If the parameters field is not provided, no additional parameters are passed and default values will be used for any special parameters such as TARGET. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.service_action.execute(
                ctx, provisioned_product_id=value, service_action_id=value, execute_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.service_action.execute provisioned_product_id=value, service_action_id=value, execute_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="execute_provisioned_product_service_action",
        op_kwargs={
            "ProvisionedProductId": provisioned_product_id,
            "ServiceActionId": service_action_id,
            "ExecuteToken": execute_token,
            "AcceptLanguage": accept_language,
            "Parameters": parameters,
        },
    )
