"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "property"


async def update_multiple(
    hub,
    ctx,
    provisioned_product_id: str,
    provisioned_product_properties: Dict,
    idempotency_token: str,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Requests updates to the properties of the specified provisioned product.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        provisioned_product_id(str): The identifier of the provisioned product.
        provisioned_product_properties(Dict): A map that contains the provisioned product properties to be updated. The LAUNCH_ROLE key accepts role ARNs. This key allows an administrator to call UpdateProvisionedProductProperties to update the launch role that is associated with a provisioned product. This role is used when an end user calls a provisioning operation such as UpdateProvisionedProduct, TerminateProvisionedProduct, or ExecuteProvisionedProductServiceAction. Only a role ARN is valid. A user ARN is invalid.  The OWNER key accepts user ARNs and role ARNs. The owner is the user that has permission to see, update, terminate, and execute service actions in the provisioned product. The administrator can change the owner of a provisioned product to another IAM user within the same account. Both end user owners and administrators can see ownership history of the provisioned product using the ListRecordHistory API. The new owner can describe all past records for the provisioned product using the DescribeRecord API. The previous owner can no longer use DescribeRecord, but can still see the product's history from when he was an owner using ListRecordHistory. If a provisioned product ownership is assigned to an end user, they can see and perform any action through the API or Service Catalog console such as update, terminate, and execute service actions. If an end user provisions a product and the owner is updated to someone else, they will no longer be able to see or perform any actions through API or the Service Catalog console on that provisioned product.
        idempotency_token(str): The idempotency token that uniquely identifies the provisioning product update request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.property_.update_multiple(
                ctx,
                provisioned_product_id=value,
                provisioned_product_properties=value,
                idempotency_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.property.update_multiple provisioned_product_id=value, provisioned_product_properties=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_provisioned_product_properties",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProvisionedProductId": provisioned_product_id,
            "ProvisionedProductProperties": provisioned_product_properties,
            "IdempotencyToken": idempotency_token,
        },
    )
