"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    plan_name: str,
    plan_type: str,
    product_id: str,
    provisioned_product_name: str,
    provisioning_artifact_id: str,
    idempotency_token: str,
    accept_language: str = None,
    notification_arns: List = None,
    path_id: str = None,
    provisioning_parameters: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a plan. A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed. You can create one plan per provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILBLE or TAINTED. To view the resource changes in the change set, use DescribeProvisionedProductPlan. To create or modify the provisioned product, use ExecuteProvisionedProductPlan.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        plan_name(str): The name of the plan.
        plan_type(str): The plan type.
        notification_arns(List, optional): Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events. Defaults to None.
        path_id(str, optional): The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use ListLaunchPaths. Defaults to None.
        product_id(str): The product identifier.
        provisioned_product_name(str): A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.
        provisioning_artifact_id(str): The identifier of the provisioning artifact.
        provisioning_parameters(List, optional): Parameters specified by the administrator that are required for provisioning the product. Defaults to None.
        idempotency_token(str): A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
        tags(List, optional): One or more tags. If the plan is for an existing provisioned product, the product must have a RESOURCE_UPDATE constraint with TagUpdatesOnProvisionedProduct set to ALLOWED to allow tag updates. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.plan.create(
                ctx,
                plan_name=value,
                plan_type=value,
                product_id=value,
                provisioned_product_name=value,
                provisioning_artifact_id=value,
                idempotency_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.plan.create plan_name=value, plan_type=value, product_id=value, provisioned_product_name=value, provisioning_artifact_id=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="create_provisioned_product_plan",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PlanName": plan_name,
            "PlanType": plan_type,
            "NotificationArns": notification_arns,
            "PathId": path_id,
            "ProductId": product_id,
            "ProvisionedProductName": provisioned_product_name,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "ProvisioningParameters": provisioning_parameters,
            "IdempotencyToken": idempotency_token,
            "Tags": tags,
        },
    )


async def delete(
    hub, ctx, plan_id: str, accept_language: str = None, ignore_errors: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified plan.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        plan_id(str): The plan identifier.
        ignore_errors(bool, optional): If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.plan.delete(
                ctx, plan_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.plan.delete plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="delete_provisioned_product_plan",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PlanId": plan_id,
            "IgnoreErrors": ignore_errors,
        },
    )


async def describe(
    hub,
    ctx,
    plan_id: str,
    accept_language: str = None,
    page_size: int = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the resource changes for the specified plan.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        plan_id(str): The plan identifier.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.plan.describe(
                ctx, plan_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.plan.describe plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_provisioned_product_plan",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PlanId": plan_id,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )


async def execute(
    hub, ctx, plan_id: str, idempotency_token: str, accept_language: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions or modifies a product based on the resource changes for the specified plan.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        plan_id(str): The plan identifier.
        idempotency_token(str): A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.plan.execute(
                ctx, plan_id=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.plan.execute plan_id=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="execute_provisioned_product_plan",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PlanId": plan_id,
            "IdempotencyToken": idempotency_token,
        },
    )


async def list_all(
    hub,
    ctx,
    accept_language: str = None,
    provision_product_id: str = None,
    page_size: int = None,
    page_token: str = None,
    access_level_filter: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the plans for the specified provisioned product or all plans to which the user has access.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        provision_product_id(str, optional): The product identifier. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        access_level_filter(Dict, optional): The access level to use to obtain results. The default is User. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.plan.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.plan.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_provisioned_product_plans",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProvisionProductId": provision_product_id,
            "PageSize": page_size,
            "PageToken": page_token,
            "AccessLevelFilter": access_level_filter,
        },
    )
