"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(
    hub,
    ctx,
    accept_language: str = None,
    provisioned_product_id: str = None,
    provisioned_product_name: str = None,
    output_keys: List = None,
    page_size: int = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This API takes either a ProvisonedProductId or a ProvisionedProductName, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        provisioned_product_id(str, optional): The identifier of the provisioned product that you want the outputs from. Defaults to None.
        provisioned_product_name(str, optional): The name of the provisioned product that you want the outputs from. Defaults to None.
        output_keys(List, optional): The list of keys that the API should return with their values. If none are provided, the API will return all outputs of the provisioned product. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.output.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.output.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="get_provisioned_product_outputs",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProvisionedProductId": provisioned_product_id,
            "ProvisionedProductName": provisioned_product_name,
            "OutputKeys": output_keys,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )
