"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub, ctx, accept_language: str = None, id_: str = None, name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified provisioned product.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        id_(str, optional): The provisioned product identifier. You must provide the name or ID, but not both. If you do not provide a name or ID, or you provide both name and ID, an InvalidParametersException will occur. Defaults to None.
        name(str, optional): The name of the provisioned product. You must provide the name or ID, but not both. If you do not provide a name or ID, or you provide both name and ID, an InvalidParametersException will occur. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_provisioned_product",
        op_kwargs={"AcceptLanguage": accept_language, "Id": id_, "Name": name},
    )


async def scan(
    hub,
    ctx,
    accept_language: str = None,
    access_level_filter: Dict = None,
    page_size: int = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the provisioned products that are available (not terminated). To use additional filtering, see SearchProvisionedProducts.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        access_level_filter(Dict, optional): The access level to use to obtain results. The default is User. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.init.scan(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.init.scan
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="scan_provisioned_products",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "AccessLevelFilter": access_level_filter,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )


async def search(
    hub,
    ctx,
    accept_language: str = None,
    access_level_filter: Dict = None,
    filters: Dict = None,
    sort_by: str = None,
    sort_order: str = None,
    page_size: int = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the provisioned products that meet the specified criteria.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        access_level_filter(Dict, optional): The access level to use to obtain results. The default is User. Defaults to None.
        filters(Dict, optional): The search filters. When the key is SearchQuery, the searchable fields are arn, createdTime, id, lastRecordId, idempotencyToken, name, physicalId, productId, provisioningArtifact, type, status, tags, userArn, userArnSession, lastProvisioningRecordId, lastSuccessfulProvisioningRecordId, productName, and provisioningArtifactName. Example: "SearchQuery":["status:AVAILABLE"] . Defaults to None.
        sort_by(str, optional): The sort field. If no value is specified, the results are not sorted. The valid values are arn, id, name, and lastRecordId. Defaults to None.
        sort_order(str, optional): The sort order. If no value is specified, the results are not sorted. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="search_provisioned_products",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "AccessLevelFilter": access_level_filter,
            "Filters": filters,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )


async def terminate(
    hub,
    ctx,
    terminate_token: str,
    provisioned_product_name: str = None,
    provisioned_product_id: str = None,
    ignore_errors: bool = None,
    accept_language: str = None,
    retain_physical_resources: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Terminates the specified provisioned product. This operation does not delete any records associated with the provisioned product. You can check the status of this request using DescribeRecord.

    Args:
        provisioned_product_name(str, optional): The name of the provisioned product. You cannot specify both ProvisionedProductName and ProvisionedProductId. Defaults to None.
        provisioned_product_id(str, optional): The identifier of the provisioned product. You cannot specify both ProvisionedProductName and ProvisionedProductId. Defaults to None.
        terminate_token(str): An idempotency token that uniquely identifies the termination request. This token is only valid during the termination process. After the provisioned product is terminated, subsequent requests to terminate the same provisioned product always return ResourceNotFound.
        ignore_errors(bool, optional): If set to true, AWS Service Catalog stops managing the specified provisioned product even if it cannot delete the underlying resources. Defaults to None.
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        retain_physical_resources(bool, optional): When this boolean parameter is set to true, the TerminateProvisionedProduct API deletes the Service Catalog provisioned product. However, it does not remove the CloudFormation stack, stack set, or the underlying resources of the deleted provisioned product. The default value is false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.init.terminate(
                ctx, terminate_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.init.terminate terminate_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="terminate_provisioned_product",
        op_kwargs={
            "ProvisionedProductName": provisioned_product_name,
            "ProvisionedProductId": provisioned_product_id,
            "TerminateToken": terminate_token,
            "IgnoreErrors": ignore_errors,
            "AcceptLanguage": accept_language,
            "RetainPhysicalResources": retain_physical_resources,
        },
    )


async def update(
    hub,
    ctx,
    update_token: str,
    accept_language: str = None,
    provisioned_product_name: str = None,
    provisioned_product_id: str = None,
    product_id: str = None,
    product_name: str = None,
    provisioning_artifact_id: str = None,
    provisioning_artifact_name: str = None,
    path_id: str = None,
    path_name: str = None,
    provisioning_parameters: List = None,
    provisioning_preferences: Dict = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Requests updates to the configuration of the specified provisioned product. If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely. You can check the status of this request using DescribeRecord.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        provisioned_product_name(str, optional): The name of the provisioned product. You cannot specify both ProvisionedProductName and ProvisionedProductId. Defaults to None.
        provisioned_product_id(str, optional): The identifier of the provisioned product. You must provide the name or ID, but not both. Defaults to None.
        product_id(str, optional): The identifier of the product. You must provide the name or ID, but not both. Defaults to None.
        product_name(str, optional): The name of the product. You must provide the name or ID, but not both. Defaults to None.
        provisioning_artifact_id(str, optional): The identifier of the provisioning artifact. Defaults to None.
        provisioning_artifact_name(str, optional): The name of the provisioning artifact. You must provide the name or ID, but not both. Defaults to None.
        path_id(str, optional): The path identifier. This value is optional if the product has a default path, and required if the product has more than one path. You must provide the name or ID, but not both. Defaults to None.
        path_name(str, optional): The name of the path. You must provide the name or ID, but not both. Defaults to None.
        provisioning_parameters(List, optional): The new parameters. Defaults to None.
        provisioning_preferences(Dict, optional): An object that contains information about the provisioning preferences for a stack set. Defaults to None.
        tags(List, optional): One or more tags. Requires the product to have RESOURCE_UPDATE constraint with TagUpdatesOnProvisionedProduct set to ALLOWED to allow tag updates. Defaults to None.
        update_token(str): The idempotency token that uniquely identifies the provisioning update request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.provisioned_product.init.update(
                ctx, update_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.provisioned_product.init.update update_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_provisioned_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProvisionedProductName": provisioned_product_name,
            "ProvisionedProductId": provisioned_product_id,
            "ProductId": product_id,
            "ProductName": product_name,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "ProvisioningArtifactName": provisioning_artifact_name,
            "PathId": path_id,
            "PathName": path_name,
            "ProvisioningParameters": provisioning_parameters,
            "ProvisioningPreferences": provisioning_preferences,
            "Tags": tags,
            "UpdateToken": update_token,
        },
    )
