"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    source_product_arn: str,
    idempotency_token: str,
    accept_language: str = None,
    target_product_id: str = None,
    target_product_name: str = None,
    source_provisioning_artifact_identifiers: List = None,
    copy_options: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Copies the specified source product to the specified target product or a new product. You can copy a product to the same account or another account. You can copy a product to the same region or another region. This operation is performed asynchronously. To track the progress of the operation, use DescribeCopyProductStatus.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        source_product_arn(str): The Amazon Resource Name (ARN) of the source product.
        target_product_id(str, optional): The identifier of the target product. By default, a new product is created. Defaults to None.
        target_product_name(str, optional): A name for the target product. The default is the name of the source product. Defaults to None.
        source_provisioning_artifact_identifiers(List, optional): The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied. Defaults to None.
        copy_options(List, optional): The copy options. If the value is CopyTags, the tags from the source product are copied to the target product. Defaults to None.
        idempotency_token(str):  A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.init.copy(
                ctx, source_product_arn=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.init.copy source_product_arn=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="copy_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "SourceProductArn": source_product_arn,
            "TargetProductId": target_product_id,
            "TargetProductName": target_product_name,
            "SourceProvisioningArtifactIdentifiers": source_provisioning_artifact_identifiers,
            "CopyOptions": copy_options,
            "IdempotencyToken": idempotency_token,
        },
    )


async def create(
    hub,
    ctx,
    name: str,
    owner: str,
    product_type: str,
    provisioning_artifact_parameters: Dict,
    idempotency_token: str,
    accept_language: str = None,
    description: str = None,
    distributor: str = None,
    support_description: str = None,
    support_email: str = None,
    support_url: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a product. A delegated admin is authorized to invoke this command. The user or role that performs this operation must have the cloudformation:GetTemplate IAM policy permission. This policy permission is required when using the ImportFromPhysicalId template source in the information data section.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        name(str): The name of the product.
        owner(str): The owner of the product.
        description(str, optional): The description of the product. Defaults to None.
        distributor(str, optional): The distributor of the product. Defaults to None.
        support_description(str, optional): The support information about the product. Defaults to None.
        support_email(str, optional): The contact email for product support. Defaults to None.
        support_url(str, optional): The contact URL for product support.  ^https?:\/\// / is the pattern used to validate SupportUrl. Defaults to None.
        product_type(str): The type of product.
        tags(List, optional): One or more tags. Defaults to None.
        provisioning_artifact_parameters(Dict): The configuration of the provisioning artifact. .
        idempotency_token(str): A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.init.create(
                ctx,
                name=value,
                owner=value,
                product_type=value,
                provisioning_artifact_parameters=value,
                idempotency_token=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.init.create name=value, owner=value, product_type=value, provisioning_artifact_parameters=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="create_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "Name": name,
            "Owner": owner,
            "Description": description,
            "Distributor": distributor,
            "SupportDescription": support_description,
            "SupportEmail": support_email,
            "SupportUrl": support_url,
            "ProductType": product_type,
            "Tags": tags,
            "ProvisioningArtifactParameters": provisioning_artifact_parameters,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(hub, ctx, id_: str, accept_language: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified product. You cannot delete a product if it was shared with you or is associated with a portfolio. A delegated admin is authorized to invoke this command.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        id_(str): The product identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="delete_product",
        op_kwargs={"AcceptLanguage": accept_language, "Id": id_},
    )


async def describe(
    hub, ctx, accept_language: str = None, id_: str = None, name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified product.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        id_(str, optional): The product identifier. Defaults to None.
        name(str, optional): The product name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_product",
        op_kwargs={"AcceptLanguage": accept_language, "Id": id_, "Name": name},
    )


async def provision(
    hub,
    ctx,
    provisioned_product_name: str,
    provision_token: str,
    accept_language: str = None,
    product_id: str = None,
    product_name: str = None,
    provisioning_artifact_id: str = None,
    provisioning_artifact_name: str = None,
    path_id: str = None,
    path_name: str = None,
    provisioning_parameters: List = None,
    provisioning_preferences: Dict = None,
    tags: List = None,
    notification_arns: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Provisions the specified product. A provisioned product is a resourced instance of a product. For example, provisioning a product based on a CloudFormation template launches a CloudFormation stack and its underlying resources. You can check the status of this request using DescribeRecord. If the request contains a tag key with an empty list of values, there is a tag conflict for that key. Do not include conflicted keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags[N]:Value".

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str, optional): The product identifier. You must provide the name or ID, but not both. Defaults to None.
        product_name(str, optional): The name of the product. You must provide the name or ID, but not both. Defaults to None.
        provisioning_artifact_id(str, optional): The identifier of the provisioning artifact. You must provide the name or ID, but not both. Defaults to None.
        provisioning_artifact_name(str, optional): The name of the provisioning artifact. You must provide the name or ID, but not both. Defaults to None.
        path_id(str, optional): The path identifier of the product. This value is optional if the product has a default path, and required if the product has more than one path. To list the paths for a product, use ListLaunchPaths. You must provide the name or ID, but not both. Defaults to None.
        path_name(str, optional): The name of the path. You must provide the name or ID, but not both. Defaults to None.
        provisioned_product_name(str): A user-friendly name for the provisioned product. This value must be unique for the AWS account and cannot be updated after the product is provisioned.
        provisioning_parameters(List, optional): Parameters specified by the administrator that are required for provisioning the product. Defaults to None.
        provisioning_preferences(Dict, optional): An object that contains information about the provisioning preferences for a stack set. Defaults to None.
        tags(List, optional): One or more tags. Defaults to None.
        notification_arns(List, optional): Passed to CloudFormation. The SNS topic ARNs to which to publish stack-related events. Defaults to None.
        provision_token(str): An idempotency token that uniquely identifies the provisioning request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.init.provision(
                ctx, provisioned_product_name=value, provision_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.init.provision provisioned_product_name=value, provision_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="provision_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "ProductName": product_name,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "ProvisioningArtifactName": provisioning_artifact_name,
            "PathId": path_id,
            "PathName": path_name,
            "ProvisionedProductName": provisioned_product_name,
            "ProvisioningParameters": provisioning_parameters,
            "ProvisioningPreferences": provisioning_preferences,
            "Tags": tags,
            "NotificationArns": notification_arns,
            "ProvisionToken": provision_token,
        },
    )


async def search(
    hub,
    ctx,
    accept_language: str = None,
    filters: Dict = None,
    page_size: int = None,
    sort_by: str = None,
    sort_order: str = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the products to which the caller has access.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        filters(Dict, optional): The search filters. If no search filters are specified, the output includes all products to which the caller has access. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        sort_by(str, optional): The sort field. If no value is specified, the results are not sorted. Defaults to None.
        sort_order(str, optional): The sort order. If no value is specified, the results are not sorted. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.init.search(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.init.search
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="search_products",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "Filters": filters,
            "PageSize": page_size,
            "SortBy": sort_by,
            "SortOrder": sort_order,
            "PageToken": page_token,
        },
    )


async def update(
    hub,
    ctx,
    id_: str,
    accept_language: str = None,
    name: str = None,
    owner: str = None,
    description: str = None,
    distributor: str = None,
    support_description: str = None,
    support_email: str = None,
    support_url: str = None,
    add_tags: List = None,
    remove_tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified product.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        id_(str): The product identifier.
        name(str, optional): The updated product name. Defaults to None.
        owner(str, optional): The updated owner of the product. Defaults to None.
        description(str, optional): The updated description of the product. Defaults to None.
        distributor(str, optional): The updated distributor of the product. Defaults to None.
        support_description(str, optional): The updated support description for the product. Defaults to None.
        support_email(str, optional): The updated support email for the product. Defaults to None.
        support_url(str, optional): The updated support URL for the product. Defaults to None.
        add_tags(List, optional): The tags to add to the product. Defaults to None.
        remove_tags(List, optional): The tags to remove from the product. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.init.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.init.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "Id": id_,
            "Name": name,
            "Owner": owner,
            "Description": description,
            "Distributor": distributor,
            "SupportDescription": support_description,
            "SupportEmail": support_email,
            "SupportUrl": support_url,
            "AddTags": add_tags,
            "RemoveTags": remove_tags,
        },
    )
