"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, product_id: str, portfolio_id: str, accept_language: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified product from the specified portfolio.  A delegated admin is authorized to invoke this command.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str): The product identifier.
        portfolio_id(str): The portfolio identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.product.from_portfolio.disassociate(
                ctx, product_id=value, portfolio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.product.from_portfolio.disassociate product_id=value, portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="disassociate_product_from_portfolio",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "PortfolioId": portfolio_id,
        },
    )
