"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    portfolio_id: str,
    principal_arn: str,
    principal_type: str,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Associates the specified principal ARN with the specified portfolio.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        principal_arn(str): The ARN of the principal (IAM user, role, or group).
        principal_type(str): The principal type. The supported value is IAM.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.principal.with_portfolio.associate(
                ctx, portfolio_id=value, principal_arn=value, principal_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.principal.with_portfolio.associate portfolio_id=value, principal_arn=value, principal_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="associate_principal_with_portfolio",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "PrincipalARN": principal_arn,
            "PrincipalType": principal_type,
        },
    )
