"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(
    hub, ctx, portfolio_id: str, principal_arn: str, accept_language: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates a previously associated principal ARN from a specified portfolio.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        principal_arn(str): The ARN of the principal (IAM user, role, or group).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.principal.from_portfolio.disassociate(
                ctx, portfolio_id=value, principal_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.principal.from_portfolio.disassociate portfolio_id=value, principal_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="disassociate_principal_from_portfolio",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "PrincipalARN": principal_arn,
        },
    )
