"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    portfolio_id: str,
    accept_language: str = None,
    page_size: int = None,
    page_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all principal ARNs associated with the specified portfolio.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.principal.for_portfolio.list(
                ctx, portfolio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.principal.for_portfolio.list portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_principals_for_portfolio",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "PageSize": page_size,
            "PageToken": page_token,
        },
    )
