"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, portfolio_share_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.

    Args:
        portfolio_share_token(str): The token for the portfolio share operation. This token is returned either by CreatePortfolioShare or by DeletePortfolioShare.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.share.status.describe(
                ctx, portfolio_share_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.share.status.describe portfolio_share_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_portfolio_share_status",
        op_kwargs={"PortfolioShareToken": portfolio_share_token},
    )
