"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def accept(
    hub,
    ctx,
    portfolio_id: str,
    accept_language: str = None,
    portfolio_share_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Accepts an offer to share the specified portfolio.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        portfolio_share_type(str, optional): The type of shared portfolios to accept. The default is to accept imported portfolios.    AWS_ORGANIZATIONS - Accept portfolios shared by the management account of your organization.    IMPORTED - Accept imported portfolios.    AWS_SERVICECATALOG - Not supported. (Throws ResourceNotFoundException.)   For example, aws servicecatalog accept-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.share.init.accept(
                ctx, portfolio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.share.init.accept portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="accept_portfolio_share",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "PortfolioShareType": portfolio_share_type,
        },
    )


async def create(
    hub,
    ctx,
    portfolio_id: str,
    accept_language: str = None,
    account_id: str = None,
    organization_node: Dict = None,
    share_tag_options: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account. Note that if a delegated admin is de-registered, they can no longer create portfolio shares.  AWSOrganizationsAccess must be enabled in order to create a portfolio share to an organization node. You can't share a shared resource, including portfolios that contain a shared product. If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the  UpdatePortfolioShare API instead.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        account_id(str, optional): The AWS account ID. For example, 123456789012. Defaults to None.
        organization_node(Dict, optional): The organization node to whom you are going to share. If OrganizationNode is passed in, PortfolioShare will be created for the node an ListOrganizationPortfolioAccessd its children (when applies), and a PortfolioShareToken will be returned in the output in order for the administrator to monitor the status of the PortfolioShare creation process. Defaults to None.
        share_tag_options(bool, optional): Enables or disables TagOptions  sharing when creating the portfolio share. If this flag is not provided, TagOptions sharing is disabled. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.share.init.create(
                ctx, portfolio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.share.init.create portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="create_portfolio_share",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "AccountId": account_id,
            "OrganizationNode": organization_node,
            "ShareTagOptions": share_tag_options,
        },
    )


async def delete(
    hub,
    ctx,
    portfolio_id: str,
    accept_language: str = None,
    account_id: str = None,
    organization_node: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator. Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        account_id(str, optional): The AWS account ID. Defaults to None.
        organization_node(Dict, optional): The organization node to whom you are going to stop sharing. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.share.init.delete(
                ctx, portfolio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.share.init.delete portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="delete_portfolio_share",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "AccountId": account_id,
            "OrganizationNode": organization_node,
        },
    )


async def describe_all(
    hub,
    ctx,
    portfolio_id: str,
    type_: str,
    page_token: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a summary of each of the portfolio shares that were created for the specified portfolio. You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share. The PortfolioId and Type parameters are both required.

    Args:
        portfolio_id(str): The unique identifier of the portfolio for which shares will be retrieved.
        type_(str): The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following: 1. ACCOUNT - Represents an external account to account share. 2. ORGANIZATION - Represents a share to an organization. This share is available to every account in the organization. 3. ORGANIZATIONAL_UNIT - Represents a share to an organizational unit. 4. ORGANIZATION_MEMBER_ACCOUNT - Represents a share to an account in the organization.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.share.init.describe_all(
                ctx, portfolio_id=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.share.init.describe_all portfolio_id=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_portfolio_shares",
        op_kwargs={
            "PortfolioId": portfolio_id,
            "Type": type_,
            "PageToken": page_token,
            "PageSize": page_size,
        },
    )


async def reject(
    hub,
    ctx,
    portfolio_id: str,
    accept_language: str = None,
    portfolio_share_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Rejects an offer to share the specified portfolio.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        portfolio_share_type(str, optional): The type of shared portfolios to reject. The default is to reject imported portfolios.    AWS_ORGANIZATIONS - Reject portfolios shared by the management account of your organization.    IMPORTED - Reject imported portfolios.    AWS_SERVICECATALOG - Not supported. (Throws ResourceNotFoundException.)   For example, aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.share.init.reject(
                ctx, portfolio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.share.init.reject portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="reject_portfolio_share",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "PortfolioShareType": portfolio_share_type,
        },
    )


async def update(
    hub,
    ctx,
    portfolio_id: str,
    accept_language: str = None,
    account_id: str = None,
    organization_node: Dict = None,
    share_tag_options: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified portfolio share. You can use this API to enable or disable TagOptions sharing for an existing portfolio share.  The portfolio share cannot be updated if the  CreatePortfolioShare operation is IN_PROGRESS, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be COMPLETED. You must provide the accountId or organization node in the input, but not both. If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke UpdatePortfolioShare separately for each share type.  This API cannot be used for removing the portfolio share. You must use DeletePortfolioShare API for that action.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The unique identifier of the portfolio for which the share will be updated.
        account_id(str, optional): The AWS Account Id of the recipient account. This field is required when updating an external account to account type share. Defaults to None.
        organization_node(Dict, optional): Information about the organization node. Defaults to None.
        share_tag_options(bool, optional): A flag to enable or disable TagOptions sharing for the portfolio share. If this field is not provided, the current state of TagOptions sharing on the portfolio share will not be modified. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.share.init.update(
                ctx, portfolio_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.share.init.update portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_portfolio_share",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "AccountId": account_id,
            "OrganizationNode": organization_node,
            "ShareTagOptions": share_tag_options,
        },
    )
