"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    display_name: str,
    provider_name: str,
    idempotency_token: str,
    accept_language: str = None,
    description: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a portfolio. A delegated admin is authorized to invoke this command.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        display_name(str): The name to use for display purposes.
        description(str, optional): The description of the portfolio. Defaults to None.
        provider_name(str): The name of the portfolio provider.
        tags(List, optional): One or more tags. Defaults to None.
        idempotency_token(str): A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.init.create(
                ctx, display_name=value, provider_name=value, idempotency_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.init.create display_name=value, provider_name=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="create_portfolio",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "DisplayName": display_name,
            "Description": description,
            "ProviderName": provider_name,
            "Tags": tags,
            "IdempotencyToken": idempotency_token,
        },
    )


async def delete(hub, ctx, id_: str, accept_language: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified portfolio. You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts. A delegated admin is authorized to invoke this command.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        id_(str): The portfolio identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="delete_portfolio",
        op_kwargs={"AcceptLanguage": accept_language, "Id": id_},
    )


async def describe(hub, ctx, id_: str, accept_language: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the specified portfolio. A delegated admin is authorized to invoke this command.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        id_(str): The portfolio identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.init.describe(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.init.describe id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_portfolio",
        op_kwargs={"AcceptLanguage": accept_language, "Id": id_},
    )


async def list_all(
    hub, ctx, accept_language: str = None, page_token: str = None, page_size: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all portfolios in the catalog.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_portfolios",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PageToken": page_token,
            "PageSize": page_size,
        },
    )


async def update(
    hub,
    ctx,
    id_: str,
    accept_language: str = None,
    display_name: str = None,
    description: str = None,
    provider_name: str = None,
    add_tags: List = None,
    remove_tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified portfolio. You cannot update a product that was shared with you.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        id_(str): The portfolio identifier.
        display_name(str, optional): The name to use for display purposes. Defaults to None.
        description(str, optional): The updated description of the portfolio. Defaults to None.
        provider_name(str, optional): The updated name of the portfolio provider. Defaults to None.
        add_tags(List, optional): The tags to add. Defaults to None.
        remove_tags(List, optional): The tags to remove. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.init.update(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.init.update id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="update_portfolio",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "Id": id_,
            "DisplayName": display_name,
            "Description": description,
            "ProviderName": provider_name,
            "AddTags": add_tags,
            "RemoveTags": remove_tags,
        },
    )
