"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    product_id: str,
    accept_language: str = None,
    page_token: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all portfolios that the specified product is associated with.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str): The product identifier.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.for_product.list(ctx, product_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.for_product.list product_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_portfolios_for_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "PageToken": page_token,
            "PageSize": page_size,
        },
    )
