"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    portfolio_id: str,
    accept_language: str = None,
    organization_parent_id: str = None,
    page_token: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the account IDs that have access to the specified portfolio. A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier.
        organization_parent_id(str, optional): The ID of an organization node the portfolio is shared with. All children of this node with an inherited portfolio share will be returned. Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.portfolio.access.list(ctx, portfolio_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.portfolio.access.list portfolio_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_portfolio_access",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "OrganizationParentId": organization_parent_id,
            "PageToken": page_token,
            "PageSize": page_size,
        },
    )
