"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    portfolio_id: str,
    organization_node_type: str,
    accept_language: str = None,
    page_token: str = None,
    page_size: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin. If a delegated admin is de-registered, they can no longer perform this operation.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        portfolio_id(str): The portfolio identifier. For example, port-2abcdext3y5fk.
        organization_node_type(str): The organization node type that will be returned in the output.    ORGANIZATION - Organization that has access to the portfolio.     ORGANIZATIONAL_UNIT - Organizational unit that has access to the portfolio within your organization.    ACCOUNT - Account that has access to the portfolio within your organization.  .
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.organization_portfolio_access.list(
                ctx, portfolio_id=value, organization_node_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.organization_portfolio_access.list portfolio_id=value, organization_node_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_organization_portfolio_access",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PortfolioId": portfolio_id,
            "OrganizationNodeType": organization_node_type,
            "PageToken": page_token,
            "PageSize": page_size,
        },
    )
