"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, copy_product_token: str, accept_language: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the status of the specified copy product operation.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        copy_product_token(str): The token for the copy product operation. This token is returned by CopyProduct.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.copy_product_status.describe(
                ctx, copy_product_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.copy_product_status.describe copy_product_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="describe_copy_product_status",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "CopyProductToken": copy_product_token,
        },
    )
