"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disassociate(hub, ctx, budget_name: str, resource_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disassociates the specified budget from the specified resource.

    Args:
        budget_name(str): The name of the budget you want to disassociate.
        resource_id(str): The resource identifier you want to disassociate from. Either a portfolio-id or a product-id.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.budget.from_resource.disassociate(
                ctx, budget_name=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.budget.from_resource.disassociate budget_name=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="disassociate_budget_from_resource",
        op_kwargs={"BudgetName": budget_name, "ResourceId": resource_id},
    )
