"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disable portfolio sharing through AWS Organizations feature. This feature will not delete your current shares but it will prevent you from creating new shares throughout your organization. Current shares will not be in sync with your organization structure if it changes after calling this API. This API can only be called by the management account in the organization. This API can't be invoked if there are active delegated administrators in the organization. Note that a delegated administrator is not authorized to invoke DisableAWSOrganizationsAccess.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.aws_organization_access.init.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.aws_organization_access.init.disable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="disable_aws_organizations_access",
        op_kwargs={},
    )


async def enable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Enable portfolio sharing feature through AWS Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization. By calling this API Service Catalog will make a call to organizations:EnableAWSServiceAccess on your behalf so that your shares can be in sync with any changes in your AWS Organizations structure. Note that a delegated administrator is not authorized to invoke EnableAWSOrganizationsAccess.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.aws_organization_access.init.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.aws_organization_access.init.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="enable_aws_organizations_access",
        op_kwargs={},
    )
