"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def import_(
    hub,
    ctx,
    product_id: str,
    provisioning_artifact_id: str,
    provisioned_product_name: str,
    physical_id: str,
    idempotency_token: str,
    accept_language: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service Catalog product and provisioning artifact. Once imported, all supported Service Catalog governance actions are supported on the provisioned product. Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets and non-root nested stacks are not supported. The CloudFormation stack must have one of the following statuses to be imported: CREATE_COMPLETE, UPDATE_COMPLETE, UPDATE_ROLLBACK_COMPLETE, IMPORT_COMPLETE, IMPORT_ROLLBACK_COMPLETE. Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact.  The user or role that performs this operation must have the cloudformation:GetTemplate and cloudformation:DescribeStacks IAM policy permissions.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        product_id(str): The product identifier.
        provisioning_artifact_id(str): The identifier of the provisioning artifact.
        provisioned_product_name(str): The user-friendly name of the provisioned product. The value must be unique for the AWS account. The name cannot be updated after the product is provisioned. .
        physical_id(str): The unique identifier of the resource to be imported. It only currently supports CloudFormation stack IDs.
        idempotency_token(str): A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.as_provisioned_product.import(ctx, product_id=value, provisioning_artifact_id=value, provisioned_product_name=value, physical_id=value, idempotency_token=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.as_provisioned_product.import product_id=value, provisioning_artifact_id=value, provisioned_product_name=value, physical_id=value, idempotency_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="import_as_provisioned_product",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "ProductId": product_id,
            "ProvisioningArtifactId": provisioning_artifact_id,
            "ProvisionedProductName": provisioned_product_name,
            "PhysicalId": physical_id,
            "IdempotencyToken": idempotency_token,
        },
    )
