"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    accept_language: str = None,
    page_token: str = None,
    page_size: int = None,
    portfolio_share_type: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists all portfolios for which sharing was accepted by this account.

    Args:
        accept_language(str, optional): The language code.    en - English (default)    jp - Japanese    zh - Chinese  . Defaults to None.
        page_token(str, optional): The page token for the next set of results. To retrieve the first set of results, use null. Defaults to None.
        page_size(int, optional): The maximum number of items to return with this call. Defaults to None.
        portfolio_share_type(str, optional): The type of shared portfolios to list. The default is to list imported portfolios.    AWS_ORGANIZATIONS - List portfolios shared by the management account of your organization    AWS_SERVICECATALOG - List default portfolios    IMPORTED - List imported portfolios  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.servicecatalog.accepted_portfolio_share.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.servicecatalog.accepted_portfolio_share.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="servicecatalog",
        operation="list_accepted_portfolio_shares",
        op_kwargs={
            "AcceptLanguage": accept_language,
            "PageToken": page_token,
            "PageSize": page_size,
            "PortfolioShareType": portfolio_share_type,
        },
    )
