"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, service_code: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the applied quota values for the specified AWS service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.

    Args:
        service_code(str): The service identifier.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quotas.list(ctx, service_code=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quotas.list service_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="list_service_quotas",
        op_kwargs={
            "ServiceCode": service_code,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
