"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Associates your quota request template with your organization. When a new account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quota.template.associate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quota.template.associate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="associate_service_quota_template",
        op_kwargs={},
    )


async def disassociate(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new accounts in your organization. Disabling a quota request template does not apply its quota increase requests.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quota.template.disassociate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quota.template.disassociate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="disassociate_service_quota_template",
        op_kwargs={},
    )
