"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, service_code: str, quota_code: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.

    Args:
        service_code(str): The service identifier.
        quota_code(str): The quota identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quota.init.get(
                ctx, service_code=value, quota_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quota.init.get service_code=value, quota_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="get_service_quota",
        op_kwargs={"ServiceCode": service_code, "QuotaCode": quota_code},
    )
