"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(
    hub, ctx, quota_code: str, service_code: str, aws_region: str, desired_value: float
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a quota increase request to your quota request template.

    Args:
        quota_code(str): The quota identifier.
        service_code(str): The service identifier.
        aws_region(str): The AWS Region.
        desired_value(float): The new, increased value for the quota.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quota.increase.request.into_template.put(
                ctx, quota_code=value, service_code=value, aws_region=value, desired_value=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quota.increase.request.into_template.put quota_code=value, service_code=value, aws_region=value, desired_value=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="put_service_quota_increase_request_into_template",
        op_kwargs={
            "QuotaCode": quota_code,
            "ServiceCode": service_code,
            "AwsRegion": aws_region,
            "DesiredValue": desired_value,
        },
    )
