"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    service_code: str = None,
    aws_region: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the quota increase requests in the specified quota request template.

    Args:
        service_code(str, optional): The service identifier. Defaults to None.
        aws_region(str, optional): The AWS Region. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quota.increase.request.in_template.list(
                ctx
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quota.increase.request.in_template.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="list_service_quota_increase_requests_in_template",
        op_kwargs={
            "ServiceCode": service_code,
            "AwsRegion": aws_region,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
