"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, service_code: str, quota_code: str, aws_region: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the quota increase request for the specified quota from your quota request template.

    Args:
        service_code(str): The service identifier.
        quota_code(str): The quota identifier.
        aws_region(str): The AWS Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quota.increase.request.from_template.delete(
                ctx, service_code=value, quota_code=value, aws_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quota.increase.request.from_template.delete service_code=value, quota_code=value, aws_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="delete_service_quota_increase_request_from_template",
        op_kwargs={
            "ServiceCode": service_code,
            "QuotaCode": quota_code,
            "AwsRegion": aws_region,
        },
    )


async def get(hub, ctx, service_code: str, quota_code: str, aws_region: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the specified quota increase request in your quota request template.

    Args:
        service_code(str): The service identifier.
        quota_code(str): The quota identifier.
        aws_region(str): The AWS Region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.quota.increase.request.from_template.get(
                ctx, service_code=value, quota_code=value, aws_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.quota.increase.request.from_template.get service_code=value, quota_code=value, aws_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="get_service_quota_increase_request_from_template",
        op_kwargs={
            "ServiceCode": service_code,
            "QuotaCode": quota_code,
            "AwsRegion": aws_region,
        },
    )
