"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the names and codes for the services integrated with Service Quotas.

    Args:
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.service.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.service.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="list_services",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
