"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, request_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about the specified quota increase request.

    Args:
        request_id(str): The ID of the quota increase request.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.requested_service_quota_change.init.get(
                ctx, request_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.requested_service_quota_change.init.get request_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="get_requested_service_quota_change",
        op_kwargs={"RequestId": request_id},
    )
