"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    service_code: str,
    quota_code: str,
    status: str = None,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the quota increase requests for the specified quota.

    Args:
        service_code(str): The service identifier.
        quota_code(str): The quota identifier.
        status(str, optional): The status value of the quota increase request. Defaults to None.
        next_token(str, optional): The token for the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return with a single call. To retrieve the remaining results, if any, make another call with the token returned from this call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.service_quotas.requested_service_quota_change.history.by_quota.list(
                ctx, service_code=value, quota_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.service_quotas.requested_service_quota_change.history.by_quota.list service_code=value, quota_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="service-quotas",
        operation="list_requested_service_quota_change_history_by_quota",
        op_kwargs={
            "ServiceCode": service_code,
            "QuotaCode": quota_code,
            "Status": status,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
