"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, application_id: str, semantic_version: str = None) -> Dict:
    r"""
        **Autogenerated function**

        Creates an AWS CloudFormation template.

        Args:
            application_id(str): The Amazon Resource Name (ARN) of the application.
            semantic_version(str, optional): The semantic version of the application:
    https://semver.org/
    . Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.serverlessrepo.cloud_formation.template.create(
                    ctx, application_id=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.serverlessrepo.cloud_formation.template.create application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="create_cloud_formation_template",
        op_kwargs={
            "ApplicationId": application_id,
            "SemanticVersion": semantic_version,
        },
    )


async def get(hub, ctx, application_id: str, template_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets the specified AWS CloudFormation template.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        template_id(str): The UUID returned by CreateCloudFormationTemplate.Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.cloud_formation.template.get(
                ctx, application_id=value, template_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.cloud_formation.template.get application_id=value, template_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="get_cloud_formation_template",
        op_kwargs={"ApplicationId": application_id, "TemplateId": template_id},
    )
