"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "change_set"


async def create(
    hub,
    ctx,
    application_id: str,
    stack_name: str,
    capabilities: List = None,
    change_set_name: str = None,
    client_token: str = None,
    description: str = None,
    notification_arns: List = None,
    parameter_overrides: List = None,
    resource_types: List = None,
    rollback_configuration: Dict = None,
    semantic_version: str = None,
    tags: List = None,
    template_id: str = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Creates an AWS CloudFormation change set for the given application.

        Args:
            application_id(str): The Amazon Resource Name (ARN) of the application.
            capabilities(List, optional): A list of values that you must specify before you can deploy certain applications.
     Some applications might include resources that can affect permissions in your AWS
     account, for example, by creating new AWS Identity and Access Management (IAM) users.
     For those applications, you must explicitly acknowledge their capabilities by
     specifying this parameter.The only valid values are CAPABILITY_IAM, CAPABILITY_NAMED_IAM,
     CAPABILITY_RESOURCE_POLICY, and CAPABILITY_AUTO_EXPAND.The following resources require you to specify CAPABILITY_IAM or
     CAPABILITY_NAMED_IAM:
     AWS::IAM::Group,
     AWS::IAM::InstanceProfile,
     AWS::IAM::Policy, and
     AWS::IAM::Role.
     If the application contains IAM resources, you can specify either CAPABILITY_IAM
     or CAPABILITY_NAMED_IAM. If the application contains IAM resources
     with custom names, you must specify CAPABILITY_NAMED_IAM.The following resources require you to specify CAPABILITY_RESOURCE_POLICY:
     AWS::Lambda::Permission,
     AWS::IAM:Policy,
     AWS::ApplicationAutoScaling::ScalingPolicy,
     AWS::S3::BucketPolicy,
     AWS::SQS::QueuePolicy, and
     AWS::SNS:TopicPolicy.Applications that contain one or more nested applications require you to specify
     CAPABILITY_AUTO_EXPAND.If your application template contains any of the above resources, we recommend that you review
     all permissions associated with the application before deploying. If you don't specify
     this parameter for an application that requires capabilities, the call will fail. Defaults to None.
            change_set_name(str, optional): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API. Defaults to None.
            client_token(str, optional): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API. Defaults to None.
            description(str, optional): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API. Defaults to None.
            notification_arns(List, optional): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API. Defaults to None.
            parameter_overrides(List, optional): A list of parameter values for the parameters of the application. Defaults to None.
            resource_types(List, optional): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API. Defaults to None.
            rollback_configuration(Dict, optional): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API. Defaults to None.
            semantic_version(str, optional): The semantic version of the application:
    https://semver.org/
    . Defaults to None.
            stack_name(str): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API.
            tags(List, optional): This property corresponds to the parameter of the same name for the AWS CloudFormation CreateChangeSet
     API. Defaults to None.
            template_id(str, optional): The UUID returned by CreateCloudFormationTemplate.Pattern: [0-9a-fA-F]{8}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{4}\-[0-9a-fA-F]{12}. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.serverlessrepo.cloud_formation.change_set_.create(
                    ctx, application_id=value, stack_name=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.serverlessrepo.cloud_formation.change_set.create application_id=value, stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="create_cloud_formation_change_set",
        op_kwargs={
            "ApplicationId": application_id,
            "Capabilities": capabilities,
            "ChangeSetName": change_set_name,
            "ClientToken": client_token,
            "Description": description,
            "NotificationArns": notification_arns,
            "ParameterOverrides": parameter_overrides,
            "ResourceTypes": resource_types,
            "RollbackConfiguration": rollback_configuration,
            "SemanticVersion": semantic_version,
            "StackName": stack_name,
            "Tags": tags,
            "TemplateId": template_id,
        },
    )
