"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    application_id: str,
    semantic_version: str,
    source_code_archive_url: str = None,
    source_code_url: str = None,
    template_body: str = None,
    template_url: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an application version.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        semantic_version(str): The semantic version of the new version.
        source_code_archive_url(str, optional): A link to the S3 object that contains the ZIP archive of the source code for this version of your application.Maximum size 50 MB. Defaults to None.
        source_code_url(str, optional): A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit. Defaults to None.
        template_body(str, optional): The raw packaged AWS SAM template of your application. Defaults to None.
        template_url(str, optional): A link to the packaged AWS SAM template of your application. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.version.create(
                ctx, application_id=value, semantic_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.version.create application_id=value, semantic_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="create_application_version",
        op_kwargs={
            "ApplicationId": application_id,
            "SemanticVersion": semantic_version,
            "SourceCodeArchiveUrl": source_code_archive_url,
            "SourceCodeUrl": source_code_url,
            "TemplateBody": template_body,
            "TemplateUrl": template_url,
        },
    )


async def list_all(
    hub, ctx, application_id: str, max_items: int = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists versions for the specified application.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        max_items(int, optional): The total number of items to return. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.version.list_all(
                ctx, application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.version.list_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="list_application_versions",
        op_kwargs={
            "ApplicationId": application_id,
            "MaxItems": max_items,
            "NextToken": next_token,
        },
    )
