"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, application_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the policy for the application.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.policy.get(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.policy.get application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="get_application_policy",
        op_kwargs={"ApplicationId": application_id},
    )


async def put(hub, ctx, application_id: str, statements: List) -> Dict:
    r"""
    **Autogenerated function**

    Sets the permission policy for an application. For the list of actions supported for this operation, see
     Application
     Permissions
     .

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        statements(List): An array of policy statements applied to the application.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.policy.put(
                ctx, application_id=value, statements=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.policy.put application_id=value, statements=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="put_application_policy",
        op_kwargs={"ApplicationId": application_id, "Statements": statements},
    )
