"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    author: str,
    description: str,
    name: str,
    home_page_url: str = None,
    labels: List = None,
    license_body: str = None,
    license_url: str = None,
    readme_body: str = None,
    readme_url: str = None,
    semantic_version: str = None,
    source_code_archive_url: str = None,
    source_code_url: str = None,
    spdx_license_id: str = None,
    template_body: str = None,
    template_url: str = None,
) -> Dict:
    r"""
        **Autogenerated function**

        Creates an application, optionally including an AWS SAM file to create the first application version in the same call.

        Args:
            author(str): The name of the author publishing the app.Minimum length=1. Maximum length=127.Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";.
            description(str): The description of the application.Minimum length=1. Maximum length=256.
            home_page_url(str, optional): A URL with more information about the application, for example the location of your GitHub repository for the application. Defaults to None.
            labels(List, optional): Labels to improve discovery of apps in search results.Minimum length=1. Maximum length=127. Maximum number of labels: 10Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";. Defaults to None.
            license_body(str, optional): A local text file that contains the license of the app that matches the spdxLicenseID value of your application.
     The file has the format file://<path>/<filename>.Maximum size 5 MBYou can specify only one of licenseBody and licenseUrl; otherwise, an error results. Defaults to None.
            license_url(str, optional): A link to the S3 object that contains the license of the app that matches the spdxLicenseID value of your application.Maximum size 5 MBYou can specify only one of licenseBody and licenseUrl; otherwise, an error results. Defaults to None.
            name(str): The name of the application that you want to publish.Minimum length=1. Maximum length=140Pattern: "[a-zA-Z0-9\\-]+";.
            readme_body(str, optional): A local text readme file in Markdown language that contains a more detailed description of the application and how it works.
     The file has the format file://<path>/<filename>.Maximum size 5 MBYou can specify only one of readmeBody and readmeUrl; otherwise, an error results. Defaults to None.
            readme_url(str, optional): A link to the S3 object in Markdown language that contains a more detailed description of the application and how it works.Maximum size 5 MBYou can specify only one of readmeBody and readmeUrl; otherwise, an error results. Defaults to None.
            semantic_version(str, optional): The semantic version of the application:
    https://semver.org/
    . Defaults to None.
            source_code_archive_url(str, optional): A link to the S3 object that contains the ZIP archive of the source code for this version of your application.Maximum size 50 MB. Defaults to None.
            source_code_url(str, optional): A link to a public repository for the source code of your application, for example the URL of a specific GitHub commit. Defaults to None.
            spdx_license_id(str, optional): A valid identifier from https://spdx.org/licenses/. Defaults to None.
            template_body(str, optional): The local raw packaged AWS SAM template file of your application.
     The file has the format file://<path>/<filename>.You can specify only one of templateBody and templateUrl; otherwise an error results. Defaults to None.
            template_url(str, optional): A link to the S3 object containing the packaged AWS SAM template of your application.You can specify only one of templateBody and templateUrl; otherwise an error results. Defaults to None.

        Returns:
            Dict

        Examples:
            Call from code:

            .. code-block:: python

                await hub.exec.aws_auto.serverlessrepo.application.init.create(
                    ctx, author=value, description=value, name=value
                )

            Call from CLI:

            .. code-block:: bash

                $ idem exec aws_auto.serverlessrepo.application.init.create author=value, description=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="create_application",
        op_kwargs={
            "Author": author,
            "Description": description,
            "HomePageUrl": home_page_url,
            "Labels": labels,
            "LicenseBody": license_body,
            "LicenseUrl": license_url,
            "Name": name,
            "ReadmeBody": readme_body,
            "ReadmeUrl": readme_url,
            "SemanticVersion": semantic_version,
            "SourceCodeArchiveUrl": source_code_archive_url,
            "SourceCodeUrl": source_code_url,
            "SpdxLicenseId": spdx_license_id,
            "TemplateBody": template_body,
            "TemplateUrl": template_url,
        },
    )


async def delete(hub, ctx, application_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified application.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.init.delete(
                ctx, application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.init.delete application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="delete_application",
        op_kwargs={"ApplicationId": application_id},
    )


async def get(hub, ctx, application_id: str, semantic_version: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the specified application.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        semantic_version(str, optional): The semantic version of the application to get. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.init.get(ctx, application_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.init.get application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="get_application",
        op_kwargs={
            "ApplicationId": application_id,
            "SemanticVersion": semantic_version,
        },
    )


async def list_all(hub, ctx, max_items: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists applications owned by the requester.

    Args:
        max_items(int, optional): The total number of items to return. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="list_applications",
        op_kwargs={"MaxItems": max_items, "NextToken": next_token},
    )


async def unshare(hub, ctx, application_id: str, organization_id: str) -> None:
    r"""
    **Autogenerated function**

    Unshares an application from an AWS Organization.This operation can be called only from the organization's master account.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        organization_id(str): The AWS Organization ID to unshare the application from.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.init.unshare(
                ctx, application_id=value, organization_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.init.unshare application_id=value, organization_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="unshare_application",
        op_kwargs={"ApplicationId": application_id, "OrganizationId": organization_id},
    )


async def update(
    hub,
    ctx,
    application_id: str,
    author: str = None,
    description: str = None,
    home_page_url: str = None,
    labels: List = None,
    readme_body: str = None,
    readme_url: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the specified application.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        author(str, optional): The name of the author publishing the app.Minimum length=1. Maximum length=127.Pattern "^[a-z0-9](([a-z0-9]|-(?!-))*[a-z0-9])?$";. Defaults to None.
        description(str, optional): The description of the application.Minimum length=1. Maximum length=256. Defaults to None.
        home_page_url(str, optional): A URL with more information about the application, for example the location of your GitHub repository for the application. Defaults to None.
        labels(List, optional): Labels to improve discovery of apps in search results.Minimum length=1. Maximum length=127. Maximum number of labels: 10Pattern: "^[a-zA-Z0-9+\\-_:\\/@]+$";. Defaults to None.
        readme_body(str, optional): A text readme file in Markdown language that contains a more detailed description of the application and how it works.Maximum size 5 MB. Defaults to None.
        readme_url(str, optional): A link to the readme file in Markdown language that contains a more detailed description of the application and how it works.Maximum size 5 MB. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.init.update(
                ctx, application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.init.update application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="update_application",
        op_kwargs={
            "ApplicationId": application_id,
            "Author": author,
            "Description": description,
            "HomePageUrl": home_page_url,
            "Labels": labels,
            "ReadmeBody": readme_body,
            "ReadmeUrl": readme_url,
        },
    )
