"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    application_id: str,
    max_items: int = None,
    next_token: str = None,
    semantic_version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the list of applications nested in the containing application.

    Args:
        application_id(str): The Amazon Resource Name (ARN) of the application.
        max_items(int, optional): The total number of items to return. Defaults to None.
        next_token(str, optional): A token to specify where to start paginating. Defaults to None.
        semantic_version(str, optional): The semantic version of the application to get. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.serverlessrepo.application.dependency.list_all(
                ctx, application_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.serverlessrepo.application.dependency.list_all application_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="serverlessrepo",
        operation="list_application_dependencies",
        op_kwargs={
            "ApplicationId": application_id,
            "MaxItems": max_items,
            "NextToken": next_token,
            "SemanticVersion": semantic_version,
        },
    )
