"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub,
    ctx,
    finding_identifiers: List,
    note: Dict = None,
    severity: Dict = None,
    verification_state: str = None,
    confidence: int = None,
    criticality: int = None,
    types: List = None,
    user_defined_fields: Dict = None,
    workflow: Dict = None,
    related_findings: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used by Security Hub customers to update information about their investigation into a finding. Requested by administrator accounts or member accounts. Administrator accounts can update findings for their account and their member accounts. Member accounts can update findings for their account. Updates from BatchUpdateFindings do not affect the value of UpdatedAt for a finding. Administrator and member accounts can use BatchUpdateFindings to update the following finding fields and objects.    Confidence     Criticality     Note     RelatedFindings     Severity     Types     UserDefinedFields     VerificationState     Workflow    You can configure IAM policies to restrict access to fields and field values. For example, you might not want member accounts to be able to suppress findings or change the finding severity. See Configuring access to BatchUpdateFindings in the Security Hub User Guide.

    Args:
        finding_identifiers(List): The list of findings to update. BatchUpdateFindings can be used to update up to 100 findings at a time. For each finding, the list provides the finding identifier and the ARN of the finding provider.
        note(Dict, optional): The updated note. Defaults to None.
        severity(Dict, optional): Used to update the finding severity. Defaults to None.
        verification_state(str, optional): Indicates the veracity of a finding. The available values for VerificationState are as follows.    UNKNOWN – The default disposition of a security finding    TRUE_POSITIVE – The security finding is confirmed    FALSE_POSITIVE – The security finding was determined to be a false alarm    BENIGN_POSITIVE – A special case of TRUE_POSITIVE where the finding doesn't pose any threat, is expected, or both  . Defaults to None.
        confidence(int, optional): The updated value for the finding confidence. Confidence is defined as the likelihood that a finding accurately identifies the behavior or issue that it was intended to identify. Confidence is scored on a 0-100 basis using a ratio scale, where 0 means zero percent confidence and 100 means 100 percent confidence. Defaults to None.
        criticality(int, optional): The updated value for the level of importance assigned to the resources associated with the findings. A score of 0 means that the underlying resources have no criticality, and a score of 100 is reserved for the most critical resources. . Defaults to None.
        types(List, optional): One or more finding types in the format of namespace/category/classifier that classify a finding. Valid namespace values are as follows.   Software and Configuration Checks   TTPs   Effects   Unusual Behaviors   Sensitive Data Identifications   . Defaults to None.
        user_defined_fields(Dict, optional): A list of name/value string pairs associated with the finding. These are custom, user-defined fields added to a finding. Defaults to None.
        workflow(Dict, optional): Used to update the workflow status of a finding. The workflow status indicates the progress of the investigation into the finding. . Defaults to None.
        related_findings(List, optional): A list of findings that are related to the updated findings. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.update_finding.batch(ctx, finding_identifiers=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.update_finding.batch finding_identifiers=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="batch_update_findings",
        op_kwargs={
            "FindingIdentifiers": finding_identifiers,
            "Note": note,
            "Severity": severity,
            "VerificationState": verification_state,
            "Confidence": confidence,
            "Criticality": criticality,
            "Types": types,
            "UserDefinedFields": user_defined_fields,
            "Workflow": workflow,
            "RelatedFindings": related_findings,
        },
    )
