"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub, ctx, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the available standards in Security Hub. For each standard, the results include the standard ARN, the name, and a description.

    Args:
        next_token(str, optional): The token that is required for pagination. On your first call to the DescribeStandards operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. Defaults to None.
        max_results(int, optional): The maximum number of standards to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.standard.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.standard.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="describe_standards",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )
