"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    standards_subscription_arn: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of security standards controls. For each control, the results include information about whether it is currently enabled, the severity, and a link to remediation information.

    Args:
        standards_subscription_arn(str): The ARN of a resource that represents your subscription to a supported standard. To get the subscription ARNs of the standards you have enabled, use the GetEnabledStandards operation.
        next_token(str, optional): The token that is required for pagination. On your first call to the DescribeStandardsControls operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. Defaults to None.
        max_results(int, optional): The maximum number of security standard controls to return. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.standard.control.describe_all(
                ctx, standards_subscription_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.standard.control.describe_all standards_subscription_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="describe_standards_controls",
        op_kwargs={
            "StandardsSubscriptionArn": standards_subscription_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def update(
    hub,
    ctx,
    standards_control_arn: str,
    control_status: str = None,
    disabled_reason: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Used to control whether an individual security standard control is enabled or disabled.

    Args:
        standards_control_arn(str): The ARN of the security standard control to enable or disable.
        control_status(str, optional): The updated status of the security standard control. Defaults to None.
        disabled_reason(str, optional): A description of the reason why you are disabling a security standard control. If you are disabling a control, then this is required. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.standard.control.update(
                ctx, standards_control_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.standard.control.update standards_control_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="update_standards_control",
        op_kwargs={
            "StandardsControlArn": standards_control_arn,
            "ControlStatus": control_status,
            "DisabledReason": disabled_reason,
        },
    )
