"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Disables Security Hub in your account only in the current Region. To disable Security Hub in all Regions, you must submit one request per Region where you have enabled Security Hub. When you disable Security Hub for an administrator account, it doesn't disable Security Hub for any associated member accounts. When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your administrator and member account associations are removed. If you want to save your existing findings, you must export them before you disable Security Hub.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.security_hub.init.disable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.security_hub.init.disable
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="securityhub", operation="disable_security_hub", op_kwargs={}
    )


async def enable(
    hub, ctx, tags: Dict = None, enable_default_standards: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Enables Security Hub for your account in the current Region or the Region you specify in the request. When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other services that are integrated with Security Hub. When you use the EnableSecurityHub operation to enable Security Hub, you also automatically enable the following standards.   CIS Amazon Web Services Foundations   Amazon Web Services Foundational Security Best Practices   You do not enable the Payment Card Industry Data Security Standard (PCI DSS) standard.  To not enable the automatically enabled standards, set EnableDefaultStandards to false. After you enable Security Hub, to enable a standard, use the BatchEnableStandards operation. To disable a standard, use the BatchDisableStandards operation. To learn more, see the setup information in the Security Hub User Guide.

    Args:
        tags(Dict, optional): The tags to add to the hub resource when you enable Security Hub. Defaults to None.
        enable_default_standards(bool, optional): Whether to enable the security standards that Security Hub has designated as automatically enabled. If you do not provide a value for EnableDefaultStandards, it is set to true. To not enable the automatically enabled standards, set EnableDefaultStandards to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.security_hub.init.enable(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.security_hub.init.enable
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="enable_security_hub",
        op_kwargs={"Tags": tags, "EnableDefaultStandards": enable_default_standards},
    )
