"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(hub, ctx, auto_enable_controls: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates configuration options for Security Hub.

    Args:
        auto_enable_controls(bool, optional): Whether to automatically enable new controls when they are added to standards that are enabled. By default, this is set to true, and new controls are enabled automatically. To not automatically enable new controls, set this to false. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.security_hub.configuration.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.security_hub.configuration.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="update_security_hub_configuration",
        op_kwargs={"AutoEnableControls": auto_enable_controls},
    )
