"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the Organizations configuration for Security Hub. Can only be called from a Security Hub administrator account.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.organization.configuration.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.organization.configuration.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="describe_organization_configuration",
        op_kwargs={},
    )


async def update(hub, ctx, auto_enable: bool) -> Dict:
    r"""
    **Autogenerated function**

    Used to update the configuration related to Organizations. Can only be called from a Security Hub administrator account.

    Args:
        auto_enable(bool): Whether to automatically enable Security Hub for new accounts in the organization. By default, this is false, and new accounts are not added automatically. To automatically enable Security Hub for new accounts, set this to true.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.organization.configuration.update(
                ctx, auto_enable=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.organization.configuration.update auto_enable=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="update_organization_configuration",
        op_kwargs={"AutoEnable": auto_enable},
    )
