"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def disable(hub, ctx, admin_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables a Security Hub administrator account. Can only be called by the organization management account.

    Args:
        admin_account_id(str): The Amazon Web Services account identifier of the Security Hub administrator account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.organization.admin_account.disable(
                ctx, admin_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.organization.admin_account.disable admin_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="disable_organization_admin_account",
        op_kwargs={"AdminAccountId": admin_account_id},
    )


async def enable(hub, ctx, admin_account_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Designates the Security Hub administrator account for an organization. Can only be called by the organization management account.

    Args:
        admin_account_id(str): The Amazon Web Services account identifier of the account to designate as the Security Hub administrator account.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.organization.admin_account.enable(
                ctx, admin_account_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.organization.admin_account.enable admin_account_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="enable_organization_admin_account",
        op_kwargs={"AdminAccountId": admin_account_id},
    )


async def list_all(hub, ctx, max_results: int = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the Security Hub administrator accounts. Can only be called by the organization management account.

    Args:
        max_results(int, optional): The maximum number of items to return in the response. Defaults to None.
        next_token(str, optional): The token that is required for pagination. On your first call to the ListOrganizationAdminAccounts operation, set the value of this parameter to NULL. For subsequent calls to the operation, to continue listing data, set the value of this parameter to the value returned from the previous response. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.securityhub.organization.admin_account.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.securityhub.organization.admin_account.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="securityhub",
        operation="list_organization_admin_accounts",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
